
#ifndef _1_CRYS_ATP_TST_DESFLOW_Acceptance_h_H
#define _1_CRYS_ATP_TST_DESFLOW_Acceptance_h_H



/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_FLOW.h"

#if TST_USE_FLOW_DATA/*In case no test vectors are selected - code disabled*/

#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 14 10:18:14 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_DESFLOW_Acceptance.h#1:incl:1
   *  \author Annag
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
   

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
typedef struct TST_DESFLOW_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];

	/* input interrupt id */
	DxUint32_t                  inputInterruptId;

	/* output interrupt id */
	DxUint32_t                  outputInterruptId;


	/* if the data in the buffers are in words and not bytes */ 
	DxUint32_t                  wordsBuffersOrderFlag;

	/* number of input buffers */
	DxUint16_t                  inputBuffersArraySize;

	/* input block size */
	//DxUint16_t                  blockSize;

	/* flag if  endian order of the input buffers is big */
	DxUint32_t                  inputBigEndianOrderFlag;

	/* number of input buffers */
	DxUint16_t                  outputBuffersArraySize;

	/* output block size */
	//DxUint16_t                  outputBlockSize;

	/* flag if  endian order of the output buffers is big */
	DxUint32_t                  outputBigEndianOrderFlag;

	DxUint8_t 			        TST_Expected_output_data[TST_FLOW_DATA_VEC_SIZE_IN_BYTS];
	
	DxUint8_t                   TST_Expected_cyclicOperation_data[TST_FLOW_DATA_VEC_SIZE_IN_BYTS];
    
	CRYS_DES_Key_t 				TST_Key;
	CRYS_DES_NumOfKeys_t		TST_NumOfKeys;
	CRYS_DES_Iv_t				TST_IvCounter;
    CRYS_DES_OperationMode_t	TST_OperationMode;
    DxUint32_t                  TST_lastInputDataSize;
	
} TST_DESFLOW_TestDataStruct;


/************************ Public Variables **********************/
/************************ Public Functions **********************/

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_DESSTATIC_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static DES FLOW API's
 
 * Algorithm:     
 *	This function initializes AES flow with static type and other parameters,
 *  sends interrupts that input and output buffers are ready, finishes AES flow, 
 *  reads data from the output buffers and compare to expected results
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_DESSTATIC_Acceptance ( void );

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_FLOW_DESDYNAMIC_Acceptance
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for dynamic AES FLOW API's

* Algorithm:     
*	This function initializes DES flow with dynamic type and other parameters,
*  sends interrupts that input and output buffers are ready, adds buffers to
*  dynamic flow, finishes DES flow, 
*  reads data from the output buffers and compare to expected results
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_DESDYNAMIC_Acceptance ( void ); 

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_FLOW_DESDYNAMIC_AddBuffers_Acceptance
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for dynamic AES FLOW API's

* Algorithm:     
*	This function initializes DES flow with dynamic type and other parameters,
*  sends interrupts that input and output buffers are ready, adds buffers to
*  dynamic flow, finishes DES flow, 
*  reads data from the output buffers and compare to expected results
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_DESDYNAMIC_AddBuffers_Acceptance ( void );


/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_FLOW_DESSTATIC_Acceptance_WithAdditionalEngines
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for static DES FLOW API's with additional engines.

* Algorithm:     
*  This function initializes DES flow with static type and other parameters,
*  sends interrupts that input and output buffers are ready, execute some AES operation
*  compare the result of the AES to expected, send interrupt that input and output buffers are ready
*  execute HASH operation , compare result of HASH to expected, finishes DES flow, 
*  execute hash operation, compare result of hash to expected,
*  reads data from the output buffers and compare to expected results
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_DESSTATIC_Acceptance_WithAdditionalEngines ( void );

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_FLOW_DESDYNAMIC_Acceptance_WithAdditionalEngines
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for dynamic DES FLOW API's with additional engines.

* Algorithm:     
*  This function initializes DES flow with dynamic type and other parameters,
*  sends interrupts that input and output buffers are ready, execute some AES operation
*  compare the result of the AES to expected, send interrupt that input and output buffers are ready
*  execute HASH operation , compare result of HASH to expected, finishes DES flow, 
*  execute hash operation, compare result of hash to expected,
*  reads data from the output buffers and compare to expected results
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_DESDYNAMIC_Acceptance_WithAdditionalEngines ( void );


/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_DESSTATIC_Cyclic_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static cyclic DES FLOW API's
 
 * Algorithm:     
 *	This function initializes DES flow with static type and other parameters,
 * and executes several times flow on the same input buffer
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_DESSTATIC_Cyclic_Acceptance ( void );

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_DES_ONETEST_Acceptance
 *  
 * Inputs:
 *  TST_index          - test index
 *  TST_MasterTestName - test name
 *  flowType           - flow type (static or dynamic)
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static DES FLOW API's
 
 * Algorithm:     
 *  1. Init DES flow
 *  2. Send interrupts that input and output buffers are ready
 *  3. Finish DES flow, read data from the output buffers and compare to expected results
 *  4. Terminate flow
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_DES_ONETEST_Acceptance ( int              TST_index, 
                                                       char             *TST_MasterTestName,
                                                       CRYS_FLOW_Type_t flowType);
                                                       
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_DESSTATIC_ONETEST_Cyclic_Acceptance
 *  
 * Inputs:
 *  TST_index          - test index
 *  TST_MasterTestName - test name 
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static cyclic DES FLOW API's
 
 * Algorithm:     
 * 1. Initialize DES flow with static type and other parameters 
 * 2. Init DES flow
 * 3. Send interrupts to execute cyclic flow operation 
 * 4. Finish DES flow
 * 5. Get results
 * 6. Terminate flow
 * 7. Read data from the output buffers and compare to expected result
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_DESSTATIC_ONETEST_Cyclic_Acceptance ( int   TST_index,
                                                                    char *TST_MasterTestName );
                                                       


/************************ Private Functions **********************/

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_FLOW_CheckDESOperation
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function checks some DES operation
* Algorithm:     
* 1. Execute some DES operation 
* 2. Compare result to expected one
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_CheckDESOperation ( void );

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_InitDESFlow
 *  
 * Inputs:
 *  TST_index          - test index
 *  flowType           - flow type (static or dynamic)
 *  TST_MasterTestName - test name
 *  TST_DESFlowId      - pointer to fill with flow id
 *  pDESFlowParamsInfo - flow params info
 *  encryptMode        - encrypt/decrypt mode
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *	This function inits DES flow.
 *
 * Algorithm:     
 *	This function starts DES flow.
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_InitDESFlow ( int                     TST_index,
                                       CRYS_FLOW_Type_t        flowType,
                                       char                   *TST_MasterTestName, 
                                       DxUint32_t             *TST_DESFlowId,
                                       CRYS_FLOW_Params_t     *pDESFlowParamsInfo,
                                       CRYS_DES_EncryptMode_t  encryptMode );
                                       
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FinishDESFlow
 *  
 * Inputs:
 *  TST_index          - test index
 *  TST_DESFlowId      - flow id
 *  TST_MasterTestName - test name
 *  blockSize          - block size for finish
 *  pDESFlowParamsInfo - flow params info
 *  encryptMode        = encrypt/decrypt mode
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *	This function finishes DES flow.
 *
 * Algorithm:     
 *	1. Finish DES flow
 *  2. Get results
 *  3. Compare output buffers with expected results
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FinishDESFlow ( int                    TST_index, 
                                         DxUint32_t             TST_DESFlowId, 
                                         char                   *TST_MasterTestName,
                                         DxUint32_t             blockSize,
                                         CRYS_FLOW_Params_t     *pDESFlowParamsInfo,
                                         CRYS_DES_EncryptMode_t encryptMode );
                                       






#ifdef __cplusplus
}
#endif

#endif

#endif
